<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);


		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/bg/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/bg/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		            	natsort($bg_images); //Sorts the array into a natural order
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		

		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		$imgs_url = get_template_directory_uri().'/images/';
		$imgs_url_demo = get_template_directory_uri().'/demo';



// Set the Options Array
global $of_options;
$of_options = array();

/*-----------------------------------------------------------------------------------*/
/* General Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__('General Settings', 'multicote-wp'),
						"type" 		=> "heading");

$of_options[] = array( 	"name" 		=> esc_html__('Custom Logo.', 'multicote-wp'),
						"desc" 		=> esc_html__('Upload a custom logo image for your site here. Size for height should be 90px or bigger for retina screens.', 'multicote-wp'),
						"id" 		=> "multicote_wp_logo",
						"std" 		=> $imgs_url.'logo.png',
						"type" 		=> "upload");

$of_options[] = array( 	"name" 		=> esc_html__('Logo Margin Top.', 'multicote-wp'),
						"desc" 		=> esc_html__('To align it perfectly, you need to give a positive margin, default is 10px', 'multicote-wp'),
						"id" 		=> "multicote_wp_logo_margin",
						"std" 		=> "0",
						"min"		=> "-10",
						"max"		=> "100",						
						"type" 		=> "sliderui");  


$of_options[] = array( 	"name" 		=> esc_html__('Home Design', 'multicote-wp'),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_choose_options_home",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Categories / Tags / Style.', 'multicote-wp') ."</h3>" . esc_html__('Select a Home Page design for categories / tags / etc.', 'multicote-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Categories / Tags / Style', 'multicote-wp'),
						"desc" 		=> esc_html__('Select a Home Page design for Categories / Tags / Author / Search / etc. page.', 'multicote-wp'),
						"id" 		=> "multicote_wp_home_select",
						"std" 		=> "0",
						"type" 		=> "select",
						"options" 	=> array(
										esc_html__( 'Small Thumbnails', 'multicote-wp' ),
										esc_html__( 'Big Thumbnails', 'multicote-wp' )
									),
					);





$of_options[] = array( 	"name" 		=> esc_html__('Featured Posts', 'multicote-wp'),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_introduction_posts",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Featured Posts', 'multicote-wp') ."</h3>
						<strong>". esc_html__('Featured Posts', 'multicote-wp') ."</strong> ". esc_html__('- Home Page Featured Posts. In order to display a post in the this section, a post need to have the tag "featured".', 'multicote-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Featured Posts', 'multicote-wp'),
						"desc" 		=> esc_html__('How many Featured Posts you want to display? Make sure some of your posts have the tag "featured" in order to be displayed.', 'multicote-wp'),
						"id" 		=> "multicote_wp_featured_posts",
						"std" 		=> "8",
						"min"		=> "1",
						"max"		=> "100",						
						"type" 		=> "sliderui");


$of_options[] = array( 	"name" 		=> esc_html__('Header Social Icons.', 'multicote-wp'),
						"desc" 		=> "",
						"id" 		=> "introduction_social",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Header Social Icons.', 'multicote-wp') ."</h3>
						<strong>". esc_html__('Social Icons', 'multicote-wp') ."</strong> ". esc_html__('- Header Social Icons.', 'multicote-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display Top Bar?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display Top Bar?', 'multicote-wp'),
						"id" 		=> "multicote_wp_topbar_display",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);

$of_options[] = array( 	"name" 		=> esc_html__('Display Social Icons?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display Social Icons?', 'multicote-wp'),
						"id" 		=> "multicote_wp_topicons_display",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);

$of_options[] = array( 	"name" 		=> esc_html__( 'Social Icons.', 'multicote-wp' ),
						"desc" 		=> "". esc_html__('You can use HTML code. For more social icons go to', 'multicote-wp') ." <a href=\"http://fontawesome.io/icons/\" target=\"_blank\">Font Awesome</a> ". esc_html__('and at the bottom you have Brand Icons!', 'multicote-wp') ."",
						"id" 		=> "multicote_wp_top_social_icons",
						"std" 		=> "<ul class=\"top-social\">
<li><a href=\"#\"><i class=\"fab fa-facebook-f\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-twitter\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-pinterest\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-youtube\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-vimeo-v\"></i></a></li>
<li><a href=\"#\"><i class=\"fas fa-rss\"></i></a></li>
</ul>",
						"type" 		=> "textarea");	




$of_options[] = array( 	"name" 		=> esc_html__('First Content Letter', 'multicote-wp'),
						"desc" 		=> "",
						"id" 		=> "introduction_letter",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('First Content Letter', 'multicote-wp') ."</h3>
						<strong>". esc_html__('First Content Letter', 'multicote-wp') ."</strong> ". esc_html__('- Display or Hide First Content Letter.', 'multicote-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display First Content Letter?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display First Content Letter?', 'multicote-wp'),
						"id" 		=> "multicote_wp_display_letter",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);





$of_options[] = array( 	"name" 		=> esc_html__('Small Author Box on article page.', 'multicote-wp'),
						"desc" 		=> "",
						"id" 		=> "introduction_social",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">". esc_html__('Small Author Box on article page.', 'multicote-wp') ."</h3>
						<strong>". esc_html__('Small Author Box', 'multicote-wp') ."</strong> ". esc_html__('- Small Author Box on article page.', 'multicote-wp') ."",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display author box?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display author box?', 'multicote-wp'),
						"id" 		=> "multicote_wp_display_smallab",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);


$of_options[] = array( 	"name" 		=> esc_html__( 'Header Popular Tags.', 'multicote-wp' ),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_introduction_tags",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Header Popular Tags.</h3> <strong>Popular Tags</strong> - Header Popular Tags, the popular tags options are mostly for the Full Width version.",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Popular Tags = 1900px.', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'How many tags you want to display, for bigger screens: 1900px', 'multicote-wp' ),
						"id" 		=> "multicote_wp_popular_tags_1",
						"std" 		=> "8",
						"min"		=> "1",
						"max"		=> "15",						
						"type" 		=> "sliderui");

$of_options[] = array( 	"name" 		=> esc_html__( 'Popular Tags = 1350px.', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'How many tags you want to display, for normal screens: 1350px', 'multicote-wp' ),
						"id" 		=> "multicote_wp_popular_tags_2",
						"std" 		=> "5",
						"min"		=> "1",
						"max"		=> "10",						
						"type" 		=> "sliderui");

$of_options[] = array( 	"name" 		=> esc_html__( 'Popular Tags = 1024px.', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'How many tags you want to display, for smaller screens: 1024px', 'multicote-wp' ),
						"id" 		=> "multicote_wp_popular_tags_3",
						"std" 		=> "3",
						"min"		=> "1",
						"max"		=> "5",						
						"type" 		=> "sliderui");






/*-----------------------------------------------------------------------------------*/
/* Advertisement Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Advertisement', 'multicote-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-money.png"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Advertisement', 'multicote-wp' ),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_introduction_banner",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Article Header Advertisement</h3><strong>Advertisement</strong> - Advertisement on Article page.",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display Advertisement?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display Advertisement?', 'multicote-wp'),
						"id" 		=> "multicote_wp_display_ad",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);

$of_options[] = array( 	"name" 		=> esc_html__( '728x90 Banner', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'The ads will be displayed in Header at the Top on Article page. Paste your HTML or JavaScript code here.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_header_728",
						"std" 		=> "<a href=\"#\"><img src=\"http://placehold.it/728x90/ffd800/FFF&amp;text=AD+BLOCK+728x90+>+Theme+Options+>+Advertisement\" width=\"728\" height=\"90\" alt=\"banner\" /></a>",
						"type" 		=> "textarea");	

 

/*-----------------------------------------------------------------------------------*/
/* Style Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Style Settings', 'multicote-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-paint.png");

$of_options[] = array( 	"name" 		=> esc_html__( 'Style', 'multicote-wp' ),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_introduction_14",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Style Settings.</h3>The style options control the main color styling of the site. <br />To change all colors of the site, open <strong>Theme folder / css / colors / default.css</strong> file.",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__( 'Main Color 1', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_main_color1",
						"std" 		=> "#23a9f6",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Main Color 2', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_main_color2",
						"std" 		=> "#000000",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Entry Link Color', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the entry link color on article or default / full width pages.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_entry_linkcolor",
						"std" 		=> "#23a9f6",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Header Background color', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the header background color to match your brand color.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_header_color",
						"std" 		=> "#000000",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Header Links color', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color of the links from the menu.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_header_links_color",
						"std" 		=> "#FFFFFF",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Thumbs rating up', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color to match your brand color.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_thumbs_up_color",
						"std" 		=> "#23a9f6",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Thumbs rating down', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Use the color picker to change the color to match your brand color.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_thumbs_down_color",
						"std" 		=> "#fe6969",
						"type" 		=> "color"
				);


$of_options[] = array( 	"name" 		=> esc_html__( 'Background Color', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Pick a background color for the theme.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_color_bg_color",
						"std" 		=> "#f8f8fa",
						"type" 		=> "color"
				);

$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Pattern Image', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'Pattern image can have any size!', 'multicote-wp' ),
						"id" 		=> "multicote_wp_pattern_footer_img",
						"std" 		=> $imgs_url.'bg.png',
						"type" 		=> "upload"
				);


/*-----------------------------------------------------------------------------------*/
/* Footer Settings */
/*-----------------------------------------------------------------------------------*/
$of_options[] = array( 	"name" 		=> esc_html__( 'Footer Settings', 'multicote-wp' ),
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-settings.png");



$of_options[] = array( 	"name" 		=> esc_html__( 'Social Icons.', 'multicote-wp' ),
						"desc" 		=> "",
						"id" 		=> "multicote_wp_introduction_social",
						"std" 		=> "<h3 style=\"margin: 0 0 10px;\">Social Icons.</h3> <strong>Social Icons</strong> - for footer.",
						"icon" 		=> true,
						"type" 		=> "info");

$of_options[] = array( 	"name" 		=> esc_html__('Display Social Icons?', 'multicote-wp'),
						"desc" 		=> esc_html__('Display Social Icons?', 'multicote-wp'),
						"id" 		=> "multicote_wp_bottomicons_display",
						"std" 		=> esc_html__( 'No', 'multicote-wp' ),
						"type" 		=> "select",
						"options" 	=> array(
									   esc_html__( 'No', 'multicote-wp' ),
									   esc_html__( 'Yes', 'multicote-wp' )
									),
					);


$of_options[] = array( 	"name" 		=> esc_html__( 'Social Icons', 'multicote-wp' ),
						"desc" 		=> "". esc_html__('You can use HTML code. For more social icons go to', 'multicote-wp') ." <a href=\"http://fontawesome.io/icons/\" target=\"_blank\">Font Awesome</a> ". esc_html__('and at the bottom you have Brand Icons!', 'multicote-wp') ."",
						"id" 		=> "multicote_wp_bottom_social_icons",
						"std" 		=> "<ul class=\"footer-social\">
<li><a href=\"#\"><i class=\"fab fa-facebook-f\"></i> <span>Facebook</span></a></li>
<li><a href=\"#\"><i class=\"fab fa-twitter\"></i> <span>Twitter</span></a></li>
<li><a href=\"#\"><i class=\"fab fa-pinterest\"></i> <span>Pinterest</span></a></li>
<li><a href=\"#\"><i class=\"fab fa-youtube\"></i> <span>Youtube</span></a></li>
<li><a href=\"#\"><i class=\"fab fa-vimeo-v\"></i> <span>Vimeo</span></a></li>
<li><a href=\"#\"><i class=\"fas fa-rss\"></i> <span>Rss</span></a></li>
</ul>",
						"type" 		=> "textarea");	

$of_options[] = array( 	"name" 		=> esc_html__( 'Copyright', 'multicote-wp' ),
						"desc" 		=> esc_html__( 'You can use HTML code.', 'multicote-wp' ),
						"id" 		=> "multicote_wp_copyright",
						"std" 		=> "Multicote is your Review Magazine Blog News WordPress Theme<br /> Copyright &copy; 2022 - Theme by <a target=\"_blank\" href=\"https://anthemes.com\">Anthemes.com</a>",
						"type" 		=> "textarea");	


				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
